#!/bin/bash

# This script automates the creation of an OCI Resource Manager (ORM) stack.
# It uses a pre-existing ZIP file containing the Terraform configuration for deployment.

# Exit immediately if a command exits with a non-zero status.
set -e

# Load environment variables (e.g., COMPARTMENT_ID, STACK_NAME, STAC_DESC) 
source "./env-vars"

# Create the Oracle Resource Manager stack and capture the OCID
stack_output=$(/users/mguiagou/lib/oracle-cli/bin/oci resource-manager stack create \
--compartment-id "$COMPARTMENT_ID" --display-name "$STACK_NAME" \
--description "$STACK_DESC" --config-source "$CONFIG_SOURCE")

# Extract the OCID of the newly created stack and display it
STACK_OCID=$(echo "$stack_output" | /usr/local/bin/jq -r '.data.id')

if [ -z "$STACK_OCID" ]; then
  echo "Error: Failed to retrieve Stack OCID from output."
  exit 1
fi

echo "Stack OCID: $STACK_OCID"

# Add the Stack OCID to the environment file
echo "" >> "./env-vars" # Add a carriage return
echo "export STACK_OCID=\"$STACK_OCID\"" >> "./env-vars"
