#!/bin/bash

set -e

# Load environment variables (e.g., STACK_OCID, EXEC_PLAN_STRATEGY)
source "./env-vars"

# Create an  jotroy for the specified stack
apply_job_output=$(/users/mguiagou/lib/oracle-cli/bin/oci resource-manager job create-destroy-job \
  --stack-id "$STACK_OCID"  \
  --execution-plan-strategy "$EXEC_PLAN_STRATEGY")

# Extract the OCID of the destroy job and check for errors
DESTROY_JOB_OCID=$(echo "$apply_job_output" | /usr/local/bin/jq -r '.data.id')

if [[ -z "$DESTROY_JOB_OCID" ]]; then
  echo "Error: Failed to retrieve destrot job OCID." >&2
  exit 1
fi

echo "Apply job OCID: $DESTROY_JOB_OCID"

# Export OCID for subsequent scripts
echo "" >> "./env-vars"
echo "export DESTROY_JOB_OCID=\"$DESTROY_JOB_OCID\"" >> "./env-vars"