##############################################################################################
# OKE Advanced Terraform Module: OKE Cluster Variables                                       #
#                                                                                            #
# File: ~/oke_advanced_module/modules/oke/variables.tf                                       #
#                                                                                            #
# Authors: Mahamat H. Guiagoussou, Payal Sharma, and Matthew McDaniel                        #
#                                                                                            #
# Copyright (c) 2025 Oracle                                                                  #
#                                                                                            #
#--------------------------------------------------------------------------------------------#
#                                                                                            #
# This file defines all input variables required for OKE cluster and node pool               #
# configuration.Review and override these values as appropriate for your environment.        #
#                                                                                            #
##############################################################################################


#********************************************************************************************#
# Global variables: Compartment OCID and Cluster Name                                        #
#********************************************************************************************#

variable "compartment_id" {
  description = "The OCID of the compartment where the OKE cluster will be created."
  type        = string
}

variable "cluster_name" {
  description = "Display name forthe OKE cluster and its components."
  type        = string
}


#********************************************************************************************#
# Core OCI and Networking Variables                                                          #
#********************************************************************************************#

variable "vcn_id" {
  description = "The OCID of the VCN where the cluster will be deployed."
  type        = string
}

variable "k8apiendpoint_private_subnet_id" {
  description = "The OCID of the Kubernetes API Endpoint private subnet."
  type        = string
}

variable "workernodes_private_subnet_id" {
  description = "The OCID of the worker nodes private subnet."
  type        = string
}

variable "pods_private_subnet_id" {
  description = "The OCID of the node pods private subnet."
  type        = string
}

variable "serviceloadbalancers_public_subnet_id" {
  description = "The OCID of the public load balancers subnet."
  type        = string
}


#********************************************************************************************#
# Controle Plane Kubernetes Version and CNI Type Handling.                                   #
#********************************************************************************************#

variable "control_plane_kubernetes_version" {
  description = "The Kubernetes version for the OKE control plane."
  type        = string
}

variable "control_plane_is_public" {
  description = "Whether the Kubernetes API endpoint should be publicly accessible."
  type        = bool
  default     = false
}

variable "cni_type" {
  description = "The CNI type for the cluster."
  type        = string
  default     = "VCN_NATIVE"
}

variable "is_cni_type_native" {
  description = "If the CNI type is native."
  type        = bool
  default     = false
}


#********************************************************************************************#
# Image, Signing, and Encryption Options                                                     #
#********************************************************************************************#

variable "image_signing_enabled" {
  description = "Whether image signing is enabled."
  type        = bool
  default     = false
}

variable "image_signing_key_id" {
  description = "The OCID of the KMS key for image signing."
  type        = string
  default     = ""
}



#********************************************************************************************#
# Cluster and Node Pool Type Configurations                                                  #
#********************************************************************************************#

variable "cluster_type" {
  description = "The type of cluster (e.g., 'ENHANCED_CLUSTER' or 'BASIC_CLUSTER')."
  type        = string
  default     = "BASIC_CLUSTER"
}

variable "is_node_pools_created" {
  description = "Set to true to create OKE node pools. False will skip creation."
  type        = bool
  default     = false
}

variable "node_pools" {
  type        = map(any)
  description = "Node pool configuration."
  # Default value that's an empty map
  default = {}
}

variable "image_id" {
  description = "The OCID of the Worker Node OS Image."
  type        = string
  default     = ""
}

variable "worker_nodes_kubernetes_version" {
  description = "The Kubernetes version for the worker nodes."
  type        = string
}


#********************************************************************************************#
# NSG Related Variables                                                                      #
#********************************************************************************************#

variable "use_nsg" {
  description = "Flag to enable NSGs instead of SLs."
  type        = bool
}

variable "k8api_nsg_id" {
  description = "The OCID of the NSG for the K8s API Endpoint (if NSGs are enabled)."
  type        = string
  default     = null
}

variable "worker_nodes_nsg_id" {
  description = "The OCID of the NSG for the OKE worker nodes (if NSGs are enabled)."
  type        = string
  default     = null
}


#********************************************************************************************#
# Cluster and Node Pool Tags (Only freeform tag is used for testing purpose only.            #
#********************************************************************************************#

# Cluster Freefrom Tag Key and Value

variable "cluster_freeform_tag_key" {
  description = "Cluster Sample Freeform Tag Key e.g.: 'Project'."
  type        = string
  default     = ""
}

variable "cluster_freeform_tag_value" {
  description = "Cluster Sample Freeform Tag value for Key e.g.: 'OCI PoC'."
  type        = string
  default     = ""
}

# Cluster Freefrom Tag Key and Value

variable "node_pool_freeform_tag_key" {
  description = "Node Pool Sample Freeform Tag Key e.g.: 'Owner'."
  type        = string
  default     = ""
}

variable "node_pool_freeform_tag_value" {
  description = "Node Pool Sample Freeform Tag value e.g.: 'Owner'."
  type        = string
  default     = ""
}


