#!/bin/bash

# Exit immediately if a command exits with a non-zero status.
set -e

# Load environment variables (e.g., STACK_OCID, EXEC_PLAN_STRATEGY)
source "./env-vars"

# Create an apply job for the specified stack
apply_job_output=$(/users/mguiagou/lib/oracle-cli/bin/oci resource-manager job create-apply-job \
  --stack-id "$STACK_OCID" \
  --execution-plan-strategy "$EXEC_PLAN_STRATEGY")

# Extract the OCID of the apply job and check for errors
APPLY_JOB_OCID=$(echo "$apply_job_output" | /usr/local/bin/jq -r '.data.id')

if [[ -z "$APPLY_JOB_OCID" ]]; then
  echo "Error: Failed to retrieve apply job OCID." >&2
  exit 1
fi

echo "Apply job OCID: $APPLY_JOB_OCID"

# Add the Apply Job OCID to the environment file
echo "" >> "./env-vars" # Add a carriage return for the next line
echo "export APPLY_JOB_OCID=\"$APPLY_JOB_OCID\"" >> "./env-vars"
