#!/bin/bash

# Exit immediately if a command exits with a non-zero status.
set -e

# Load environment variables (e.g., COMPARTMENT_ID, STACK_NAME, etc.)
source "./env-vars"

# Create a plan job for the specified stack
plan_job_output=$(/users/mguiagou/lib/oracle-cli/bin/oci resource-manager job create-plan-job \
  --stack-id "$STACK_OCID")

# Extract the OCID of the plan job and check for errors
PLAN_JOB_OCID=$(echo "$plan_job_output" | /usr/local/bin/jq -r '.data.id')

if [[ -z "$PLAN_JOB_OCID" ]]; then
  echo "Error: Failed to retrieve plan job OCID." >&2
  exit 1
fi

echo "Plan job OCID: $PLAN_JOB_OCID"

# Add the Plan Job OCID to the environment file
echo "" >> "./env-vars" # Add a carriage return 
echo "export PLAN_JOB_OCID=\"$PLAN_JOB_OCID\"" >> "./env-vars"