#################################################################################
#  OKE Advanced Terraform Root Module                                           #
#  File: ~/oke_advanced_module/terraform.tfvars                                 #
#                                                                               #
#  Description:                                                                 #
#    Terraform variable values for Oracle Kubernetes Engine (OKE) deployments.  #
#    Edit this file to set environment and project-specific parameters for      #
#    network, cluster, node pool, and bastion configuration.                    #
#                                                                               #
#  Authors: Mahamat H. Guiagoussou, Payal Sharma, Matthew McDaniel              #
#  Copyright (c) 2025 Oracle                                                    #
#################################################################################


#--------------------- API Authtentication Variables ----------------------------------------#

tenancy_ocid     = "REPLACE_WITH_YOUR_TENANCY_OCID"         #"ocid1.tenancy.oc1..xxxxxxxx"
user_ocid        = "REPLACE_WITH_USER_OCID"                 #"ocid1.user.oc1..xxxxxxxx"
fingerprint      = "REPLACE_WITH_FINGERPRINT_OF_PRIVAYEKEY" #"XX:XX:XX:XX:XX:XX:XX:XX:XX:XX:XX:XX:XX:XX:XX:XX"
private_key_path = "REPLACE_WITH_PRIVATE_KEYPATH"           #"/path/to/your/oci_api_key.pem"
region           = "REPLACE_WITH_REGION_KEY"                #"us-ashburn-1"


#--------------------- Global Variables ----------------------------------------#

is_networking_compartment_separate = REPLACE_BY_YOUR_BOOL        # true

compartment_id = "REPLACE_BY_YOUR_COMPARTMENT_OCID"              # "ocid1.compartment.oc1..xxxxx"

networking_compartment_id = "REPLACE_BY_YOUR_NETWORK_COMPARTMENT_OCID" # "ocid1.compartment.oc1..xxxxx"

display_name_prefix = "REPLACE_BY_YOUR_DISPLAY_NAME_PREFIX"      # "CLI-OKE-Module-Test"


#--------------------------------------------------------------------------------#
# STEP 1: Create Network Resources                                               #
#--------------------------------------------------------------------------------#
is_vcn_created   = REPLACE_BY_YOUR_BOOL                # true
host_name_prefix = "REPLACE_BY_YOUR_HOSTNAME_PREFIX"   # "avcn"

vcn_cidr_block                                = "REPLACE_BY_YOUR_VCN_CIDR"                   # "10.0.0.0/16"
k8apiendpoint_private_subnet_cidr_block       = "REPLACE_BY_YOUR_K8S_API_SUBNET_CIDR"        # "10.0.0.0/30"
workernodes_private_subnet_cidr_block         = "REPLACE_BY_YOUR_WORKER_NODES_SUBNET_CIDR"   # "10.0.1.0/24"
pods_private_subnet_cidr_block                = "REPLACE_BY_YOUR_PODS_SUBNET_CIDR"           # "10.0.32.0/19"
serviceloadbalancers_public_subnet_cidr_block = "REPLACE_BY_YOUR_LB_PUBLIC_SUBNET_CIDR"      # "10.0.2.0/24"
bastion_public_subnet_cidr_block              = "REPLACE_BY_YOUR_BASTION_PUBLIC_SUBNET_CIDR" # "10.0.3.0/24"


#--------------------------------------------------------------------------------#
# STEP 2: Create an OKE Cluster                                                  #
#--------------------------------------------------------------------------------#
is_k8cluster_created             = REPLACE_BY_YOUR_BOOL           # true
worker_nodes_kubernetes_version  = "REPLACE_BY_YOUR_VERSION"      # "v1.33.1"
control_plane_kubernetes_version = "REPLACE_BY_YOUR_VERSION"      # "v1.33.1"
cni_type                         = "REPLACE_BY_YOUR_CNI_TYPE"     # "OCI_VCN_IP_NATIVE" or "FLANNEL_OVERLAY"
cluster_type                     = "REPLACE_BY_YOUR_CLUSTER_TYPE" # "ENHANCED_CLUSTER" pr "BASIC"
control_plane_is_public          = REPLACE_BY_YOUR_BOOL           # false
image_signing_enabled            = REPLACE_BY_YOUR_BOOL           # false

cluster_freeform_tag_key   = "REPLACE_BY_YOUR_FREEFORM_TAG_KEY"   # "Environment"
cluster_freeform_tag_value = "REPLACE_BY_YOUR_FREEFORM_TAG_VALUE" # "Development"


#--------------------------------------------------------------------------------#
# STEP 3: Create Node Pool for the Cluster                                       #
#--------------------------------------------------------------------------------#
is_nodepool_created = REPLACE_BY_YOUR_BOOL       # true
worker_node_pools = {
  node_pools = {
    name  = "REPLACE_BY_YOUR_POOL_NAME"          # "test_node_pool"
    shape = "REPLACE_BY_YOUR_SHAPE"              # "VM.Standard.E5.Flex"
    shape_config = {
      memory = REPLACE_BY_YOUR_MEMORY_GB         # 16
      ocpus  = REPLACE_BY_YOUR_OCPUS             # 1
    }
    boot_volume_size   = REPLACE_BY_YOUR_BOOT_VOL_SIZE # 50
    operating_system   = "REPLACE_BY_YOUR_OS"          # "Oracle-Linux"
    kubernetes_version = "REPLACE_BY_YOUR_VERSION"     # "v1.33"
    source_type        = "REPLACE_BY_YOUR_SOURCE"      # "IMAGE"
    node_labels = {
      Trigger = "REPLACE_BY_YOUR_TRIGGER_LABEL"        # "Nodes_Cycling_0"
    }
    availability_domains = [
      "REPLACE_BY_YOUR_AD_1",                         # "AQob:US-ASHBURN-AD-1"
      "REPLACE_BY_YOUR_AD_2",                         # "AQob:US-ASHBURN-AD-2"
      "REPLACE_BY_YOUR_AD_3"                          # "AQob:US-ASHBURN-AD-3"
    ]
    number_of_nodes          = REPLACE_BY_YOUR_POOL_SIZE     # 1, 3, 4....
    pv_in_transit_encryption = REPLACE_BY_YOUR_BOOL          # false
    node_cycle_config = {
      node_cycling_enabled = REPLACE_BY_YOUR_BOOL            # true
      maximum_surge        = REPLACE_BY_YOUR_MAX_SURGE       # 1
      maximum_unavailable  = REPLACE_BY_YOUR_MAX_UNAVAILABLE # 0
      cycle_modes          = REPLACE_BY_YOUR_Cycle_mode	     # cycle_modes"BOOT_VOLUME_REPLACE" or "INSTANCE_REPLACE"
    }
    ssh_key = "REPLACE_BY_YOUR_NODE_POOL_SSH_KEY"            # "oke_node_key.pub"
  }
}
node_pool_freeform_tag_key   = "REPLACE_BY_YOUR_TAG_KEY"   # "LOB"
node_pool_freeform_tag_value = "REPLACE_BY_YOUR_TAG_VALUE" # "DevOps Tech"


#--------------------------------------------------------------------------------#
# STEP 4: Create Bastion Host (for OKE cluster administration)                   #
#--------------------------------------------------------------------------------#
is_bastion_created   = REPLACE_BY_YOUR_BOOL            # true
ssh_public_key_path  = "REPLACE_BY_YOUR_PUBLIC_KEY"    # "oke_node_key.pub"
ssh_private_key_path = "REPLACE_BY_YOUR_PRIVATE_KEY"   # "oke_node_key"

linux_images = {
  us-ashburn-1 = {
    ol8_1_25_4 = "REPLACE_BY_YOUR_IMAGE_OCID"   # "ocid1.image.oc1.iad.aaaa...""
    ol8_1_24_1 = "REPLACE_BY_YOUR_IMAGE_OCID"   # "ocid1.image.oc1.iad.aaaa..."
  }
  us-phoenix-1 = {
    ol8_1_25_4 = "REPLACE_BY_YOUR_IMAGE_OCID"   # "ocid1.image.oc1.iad.aaaa..."
    ol8_1_24_1 = "REPLACE_BY_YOUR_IMAGE_OCID"   # "ocid1.image.oc1.iad.aaaa..."
  }
}

bastion_params = {
  this_bastion = {
    ad_number    = REPLACE_BY_YOUR_AVAILABILITY_DOMAIN_NB   # 1
    fault_domain = REPLACE_BY_YOUR_FAULT_DOMAIN_NB          # 1
    shape        = "REPLACE_BY_YOUR_BASTION_SHAPE"  # "VM.Standard.E5.Flex"
    shape_config = {
      memory = REPLACE_BY_YOUR_BASTION_MEMORY        # 12
      ocpus  = REPLACE_BY_YOUR_BASTION_OCPUS         # 1
    }
    platform_config = {
      is_symmetric_multi_threading_enabled = "REPLACE_BY_YOUR_SMT" # true
      type                                 = "REPLACE_BY_YOUR_TYPE" # "AMD_VM"
    }
    hostname                                        = "REPLACE_BY_YOUR_HOSTNAME"      # "tfokebh"
    version                                         = "REPLACE_BY_YOUR_VERSION"       # "ol8_1_25_4"
    boot_volume_size                                = REPLACE_BY_YOUR_BOOT_VOL_SIZE   # 50
    assign_public_ip                                = REPLACE_BY_YOUR_BOOL            # true
    preserve_boot_volume                            = REPLACE_BY_YOUR_BOOL            # false
    instance_options_legacy_imds_endpoints_disabled = REPLACE_BY_YOUR_BOOL            # false
    freeform_tags = {
      project     = "REPLACE_BY_YOUR_PROJECT"       # "devops"
      environment = "REPLACE_BY_YOUR_ENV"           # "production"
    }
  }
}