##################################################################################
# OKE Advanced Terraform Root Module: File: ~/oke_advanced_module/provider.tf    #
#                                                                                #
# Description:                                                                   #
#   Provider config for OKE advanced root module—Oracle Resource Manager (ORM).  #
#   No explicit authentication required: ORM authenticates through the Console.  #
#   Only region is needed.                                                       #
#                                                                                #
#   Best Practices:                                                              #
#     - Never commit sensitive variables; ORM handles authentication securely.   #
#     - Pin provider versions and update with OCI documentation guidance.        #
#                                                                                #
# Authors: Mahamat H. Guiagoussou, Payal Sharma, Matthew McDaniel                #
# Copyright (c) 2025 Oracle                                                      #
##################################################################################


#-------------------------------------------------------#
# OCI Provider Configuration - Oracle Resource Manager  #
#-------------------------------------------------------#

provider "oci" {
  region = var.region
}