import * as AccUtils from "../accUtils";
import * as ko from "knockout";
import MutableArrayDataProvider = require("ojs/ojmutablearraydataprovider");
import "ojs/ojselectsingle";
import "ojs/ojlabel";
import "ojs/ojchart";
import * as storeData from "text!../store_data.json";
import "ojs/ojlistview";
import * as ResponsiveUtils from "ojs/ojresponsiveutils";
import * as ResponsiveKnockoutUtils from "ojs/ojresponsiveknockoututils";
import * as HtmlUtils from "ojs/ojhtmlutils";
import "ojs/ojmodule-element";

type ChartType = {
  value: string;
  label: string;
};

type Activity = {
  id: number;
};

class DashboardViewModel {
  chartTypes: Array<Object>;
  chartTypesDP: MutableArrayDataProvider<ChartType["value"], ChartType>;
  chartData: Array<Object>;
  chartDataProvider: MutableArrayDataProvider<string, {}>;
  activityDataProvider: MutableArrayDataProvider<Activity["id"], Activity>;
  val: ko.Observable<string>;
  large: ko.Observable<boolean>;
  moduleConfig: ko.PureComputed<any>;

  constructor() {
    this.val = ko.observable("pie");
    this.chartData = [
      { id: 0, series: "Baseball", group: "Group A", value: 42 },
      { id: 1, series: "Baseball", group: "Group B", value: 34 },
      { id: 2, series: "Bicycling", group: "Group A", value: 55 },
      { id: 3, series: "Bicycling", group: "Group B", value: 30 },
      { id: 4, series: "Skiing", group: "Group A", value: 36 },
      { id: 5, series: "Skiing", group: "Group B", value: 50 },
      { id: 6, series: "Soccer", group: "Group A", value: 22 },
      { id: 7, series: "Soccer", group: "Group B", value: 46 },
    ];

    this.chartDataProvider = new MutableArrayDataProvider(this.chartData, {
      keyAttributes: "id",
    });

    // Define the oj-module inline template for Activity Items list
    const lg_xl_view =
      '<h3 id="activityItemsHeader">Activity Items</h3>' +
      '<oj-list-view style="font-size: 18px" aria-labelledby="activityItemsHeader">' +
      "<ul>" +
      "<li>" +
      '<div class="oj-flex-item">' +
      "<p>SureCatch Baseball Glove</p>" +
      "<p>Western R16 Helmet</p>" +
      "<p>Western C1 Helmet</p>" +
      "<p>Western Bat</p>" +
      "</div>" +
      "</li>" +
      "<li>" +
      '<div class="oj-flex-item">' +
      "<p>Air-Lift Tire Pump</p>" +
      "<p>Intact Bike Helmet</p>" +
      "<p>Nimbus Bike Tire</p>" +
      "<p>Refill Water Bottle</p>" +
      "<p>Swift Boys 21 Speed</p>" +
      "</div>" +
      "</li>" +
      "</ul>" +
      "</oj-list-view>";

    // Display this content for small and medium screen sizes
    const sm_md_view =
      '<div id="sm_md" style="background-color:lightcyan; padding: 10px; font-size: 10px">' +
      '<h3 id="activityDetailsHeader">Activity Details</h3>' +
      '<oj-list-view style="font-size: 18px" aria-labelledby="activityDetailsHeader">' +
      "<ul>" +
      "<li>" +
      '<div class="oj-flex-item">' +
      "<p>SureCatch Baseball Glove</p>" +
      "<p>Western R16 Helmet</p>" +
      "<p>Western C1 Helmet</p>" +
      "<p>Western Bat</p>" +
      "</div>" +
      "</li>" +
      "</ul>" +
      "</oj-list-view>" +
      "</div>";

    // Identify the screen size and display the content for that screen size
    const lgQuery = ResponsiveUtils.getFrameworkQuery(
      ResponsiveUtils.FRAMEWORK_QUERY_KEY.LG_UP
    );

    this.large = ResponsiveKnockoutUtils.createMediaQueryObservable(lgQuery);
    this.moduleConfig = ko.pureComputed(() => {
      let viewNodes = HtmlUtils.stringToNodeArray(
        this.large() ? lg_xl_view : sm_md_view
      );
      return { view: viewNodes };
    });

    /**
     * End of oj-module code
     */

    this.chartTypes = [
      { value: "pie", label: "Pie" },
      { value: "bar", label: "Bar" },
    ];

    this.chartTypesDP = new MutableArrayDataProvider<
      ChartType["value"],
      ChartType
    >(this.chartTypes, {
      keyAttributes: "value",
    });

    this.activityDataProvider = new MutableArrayDataProvider<
      Activity["id"],
      Activity
    >(JSON.parse(storeData), {
      keyAttributes: "id",
    });
  }

  /**
   * Optional ViewModel method invoked after the View is inserted into the
   * document DOM.  The application can put logic that requires the DOM being
   * attached here.
   * This method might be called multiple times - after the View is created
   * and inserted into the DOM and after the View is reconnected
   * after being disconnected.
   */
  connected(): void {
    AccUtils.announce("Dashboard page loaded.");
    document.title = "Dashboard";
    // implement further logic if needed
  }

  /**
   * Optional ViewModel method invoked after the View is disconnected from the DOM.
   */
  disconnected(): void {
    // implement if needed
  }

  /**
   * Optional ViewModel method invoked after transition to the new View is complete.
   * That includes any possible animation between the old and the new View.
   */
  transitionCompleted(): void {
    // implement if needed
  }
}

export = DashboardViewModel;
