import { h, ComponentProps } from "preact";
import "ojs/ojavatar";
import MutableArrayDataProvider = require("ojs/ojmutablearraydataprovider");
import "ojs/ojchart";
import { ojChart } from "ojs/ojchart";


// import * as storeData from "text!../store_data.json";
// import "ojs/ojlistview";
// import { ojListView } from "ojs/ojlistview";
// import "ojs/ojlistitemlayout";

type Props = {
  item?: Item;
};

type Item = {
  id: number;
  name: string;
  short_desc?: string;
  price?: number;
  quantity?: number;
  quantity_shipped?: number;
  quantity_instock?: number;
  activity_id?: number;
  image?: string;
};

type ChartItem = {
  id: number;
  series: string;
  group: string;
  value: number;
};

type ChartProps = ComponentProps<"oj-chart">;

type Activity = {
  id: number;
  name: string;
};

// const activityDataProvider = new MutableArrayDataProvider<Activity["id"], Activity>(JSON.parse(storeData), {
//   keyAttributes: "id",
// });

// type ListViewProps = ComponentProps<"oj-list-view">;
// const gridlinesItemVisible: ListViewProps["gridlines"] = { item: "visible" };

const ItemDetailContainer = (props: Props) => {
  const chartItem = (item: ojChart.ItemTemplateContext<ChartItem["id"], ChartItem>) => {
    return <oj-chart-item value={item.data.value} groupId={[0]} seriesId={item.data.series}></oj-chart-item>;
  };

  // const renderListItem = (item: ojListView.ItemTemplateContext<Activity["id"], Activity>) => {
  //   return (
  //     <li>
  //       <oj-list-item-layout>
  //         <div class="oj-typography-body-md">{item.data.name}</div>
  //       </oj-list-item-layout>
  //     </li>
  //   );
  // };

  const pieDataProvider: MutableArrayDataProvider<ChartItem["id"], ChartItem> = new MutableArrayDataProvider(
    [
      { series: "Quantity in Stock", value: props.item.quantity_instock },
      { series: "Quantity shipped", value: props.item.quantity_shipped },
    ],
    { keyAttributes: "id" }
  );

  return (
    <div id="itemDetailsContainer" class="oj-flex-item oj-sm-padding-4x-start oj-md-6 oj-sm-12">
      <h3>Item Details</h3>
      <hr class="hr-margin" />
      <oj-avatar role="img" size="lg" aria-label={"product image for" + props.item.name} src={props.item?.image?.replace("css", "styles")} class="float-right"></oj-avatar>
      <div id="itemName" class="data-name">
        {props.item.name}
      </div>
      <div id="itemDesc" class="data-desc">
        {props.item.short_desc}
      </div>
      <div id="itemPrice">{"Price: " + props.item.price + " each"}</div>
      <div id="itemId">{"Item Id: " + props.item.id}</div>
      <div>
        <oj-chart id="pieChart" type="pie" data={pieDataProvider} animationOnDisplay="auto" animationOnDataChange="auto" hoverBehavior="dim" class="chartStyle">
          <template slot="itemTemplate" render={chartItem}></template>
        </oj-chart>
      </div>
    </div>
  );
};
export default ItemDetailContainer;
