##############################################################################################
# OKE Advanced Terraform Module: Bastion Host Outputs                                        #
#                                                                                            #
# File: ~/oke_advanced_module/modules/bastion/outputs.tf                                     #
#                                                                                            #
# Authors: Mahamat H. Guiagoussou, Payal Sharma, and Matthew McDaniel                        #
#                                                                                            #
# Copyright (c) 2025 Oracle                                                                  #
#                                                                                            #
#--------------------------------------------------------------------------------------------#
#                                                                                            #
# Outputs related to the Bastion Host resources. These are used to provide access            #
# information (such as public IPs and display names) for the deployed bastion instance(s).   #
#                                                                                            #
##############################################################################################


#*******************************************************************************************#
# Output: bastion_public_ips                                                                #
# Returns a map of bastion instance hostnames to their public IP addresses                  #
#*******************************************************************************************#
output "bastion_public_ips" {
  description = "A map of bastion instance hostnames to their public IP addresses."
  value = {
    for hostname, instance in oci_core_instance.this :
    hostname => instance.public_ip
  }
}


#*******************************************************************************************#
# Output: bastion_display_name                                                              #
# Returns a map of bastion instance hostnames to their display names                        #
#*******************************************************************************************#
output "bastion_display_name" {
  description = "A map of bastion instance hostnames."
  value = {
    for hostname, instance in oci_core_instance.this :
    hostname => instance.display_name
  }
}
