##############################################################################################
# OKE Advanced Terraform Module: Bastion Host Variables                                      #
#                                                                                            #
# File: ~/oke_advanced_module/modules/bastion/variables.tf                                   #
#                                                                                            #
# Authors: Mahamat H. Guiagoussou, Payal Sharma, and Matthew McDaniel                        #
#                                                                                            #
# Copyright (c) 2025 Oracle                                                                  #
#                                                                                            #
#--------------------------------------------------------------------------------------------#
#                                                                                            #
# This file defines all input variables required for configuring the Bastion Host            #
# for secure access to private nodes in an OCI Kubernetes (OKE) environment.                 #
#                                                                                            #
##############################################################################################


#********************************************************************************************#
# Core OCI Identifiers and Resource Location Variables                                       #
#********************************************************************************************#

variable "root_compartment_id" {
  description = "The OCID of the root (tenancy) compartment to fetch the availability domains."
  type        = string
}

variable "compartment_id" {
  description = "The OCID of the compartment where the Bastion will be created."
  type        = string
}

variable "region" {
  description = "The OCI region where the resources are deployed."
  type        = string
}

variable "bastion_subnet_id" {
  description = "The OCID of the subnet where the bastion instance will be deployed."
  type        = string
}


#********************************************************************************************#
# Operating System Image and SSH Key Variables                                               #
#********************************************************************************************#


# This module uses Linux images by default, but you can extend it to other OS images.
variable "linux_images" {
  description = "A map of Linux image OCIDs, keyed by region and version."
  type        = map(any)
}


variable "public_key_path" {
  description = "Path to the public SSH key."
  type        = string
  sensitive   = true # Recommended for key material paths
}

variable "private_key_path" {
  description = "Path to the private SSH key."
  type        = string
  sensitive   = true # Recommended for key material paths
}

variable "display_name" {
  description = "Bastion Host Display Name."
  type        = string
}


#********************************************************************************************#
# Bastion Host Instance Configuration                                                        #
#********************************************************************************************#


variable "bastion_params" {
  description = "A map of bastion instance configurations."
  type = map(object({
    ad_number    = number
    fault_domain = number
    shape        = string
    shape_config = object({
      memory = number
      ocpus  = number
    })
    hostname             = string
    version              = string
    boot_volume_size     = number
    assign_public_ip     = bool
    preserve_boot_volume = bool
    freeform_tags        = map(string)
    platform_config = object({
      is_symmetric_multi_threading_enabled = bool
      type  = string
    })
    instance_options_legacy_imds_endpoints_disabled = bool
  }))
}

#*************************************************************************************#
# Network Security Group (NSG) Integration                                            #
#*************************************************************************************#

variable "use_nsg" {
  description = "Flag to enable NSGs instead of SLs."
  type        = bool
}

variable "bastion_nsg_id" {
  description = "The OCID of the NSG for the Bastion host (if NSGs are enabled)."
  type        = string
  default     = null
}
