define(["require", "exports", "knockout", "ojL10n!./resources/nls/demo-update-item-strings", "ojs/ojcontext", "ojs/ojresponsiveutils", "ojs/ojresponsiveknockoututils", "ojs/ojconverter-number", "ojs/ojasyncvalidator-length", "ojs/ojknockout", "ojs/ojformlayout", "ojs/ojinputtext", "ojs/ojlabelvalue"], function (require, exports, ko, componentStrings, Context, ResponsiveUtils, ResponsiveKnockoutUtils, ojconverter_number_1, AsyncLengthValidator) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    class ViewModel {
        constructor(context) {
            this.smallQuery = ResponsiveUtils.getFrameworkQuery(ResponsiveUtils.FRAMEWORK_QUERY_KEY.SM_ONLY);
            this.isSmall = ResponsiveKnockoutUtils.createMediaQueryObservable(this.smallQuery);
            // For small screens: labels on top
            // For medium or bigger: labels at the start
            this.labelEdge = ko.computed(() => {
                return this.isSmall() ? "top" : "start";
            }, this);
            //At the start of your viewModel constructor
            const elementContext = Context.getContext(context.element);
            const busyContext = elementContext.getBusyContext();
            const options = { "description": "Web Component Startup - Waiting for data" };
            this.busyResolve = busyContext.addBusyState(options);
            this.composite = context.element;
            //Example observable
            this.messageText = ko.observable("Hello from demo-update-item");
            this.properties = context.properties;
            this.res = componentStrings["demo-update-item"];
            this.currency = new ojconverter_number_1.IntlNumberConverter({
                style: "currency",
                currency: "USD ",
                currencyDisplay: "code",
            });
            this.lengthValue1 = ko.observable("");
            this.validators = ko.observableArray([
                new AsyncLengthValidator({ min: 5, max: 50 }),
            ]);
            // Example for parsing context properties
            // if (context.properties.name) {
            //     parse the context properties here
            // }
            //Once all startup and async activities have finished, relocate if there are any async activities
            this.busyResolve();
        }
        //Lifecycle methods - implement if necessary 
        activated(context) {
        }
        ;
        connected(context) {
        }
        ;
        bindingsApplied(context) {
        }
        ;
        propertyChanged(context) {
        }
        ;
        disconnected(element) {
        }
        ;
    }
    exports.default = ViewModel;
    ;
});
//# sourceMappingURL=demo-update-item-viewModel.js.map