/// <reference types="ojasyncvalidator-length" />
import * as ko from "knockout";
import Composite = require("ojs/ojcomposite");
import "ojs/ojknockout";
import "ojs/ojformlayout";
import "ojs/ojinputtext";
import "ojs/ojlabelvalue";
import { IntlNumberConverter } from "ojs/ojconverter-number";
import AsyncLengthValidator = require("ojs/ojasyncvalidator-length");
export default class ViewModel implements Composite.ViewModel<Composite.PropertiesType> {
    busyResolve: (() => void);
    composite: Element;
    messageText: ko.Observable<string>;
    properties: Composite.PropertiesType;
    res: {
        [key: string]: string;
    };
    smallQuery: string;
    isSmall: ko.Observable;
    labelEdge: ko.Computed;
    currency: IntlNumberConverter;
    lengthValue1: ko.Observable<string>;
    validators: ko.ObservableArray<AsyncLengthValidator<string>>;
    constructor(context: Composite.ViewModelContext<Composite.PropertiesType>);
    activated(context: Composite.ViewModelContext<Composite.PropertiesType>): Promise<any> | void;
    connected(context: Composite.ViewModelContext<Composite.PropertiesType>): void;
    bindingsApplied(context: Composite.ViewModelContext<Composite.PropertiesType>): void;
    propertyChanged(context: Composite.PropertyChangedContext<Composite.PropertiesType>): void;
    disconnected(element: Element): void;
}
