define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"About This Content",
                    "href":"this-content.html#GUID-808FB4B1-CBF5-45DF-9595-6F9B28542F60"
                },
                {
                    "title":"What's New",
                    "href":"whats-new.html#GUID-DF779E57-732B-4BB7-AA12-8EC090A06C7E"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Paths to Explore Cache in TimesTen",
                    "href":"paths-learning-cache-timesten.html#GUID-14FFDEDC-25BE-4529-A28F-19229C712D28"
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Cache Concepts",
                    "href":"cache-concepts.html#GUID-43A47719-4356-41AB-987C-5ECD5D237189",
                    "topics":[
                        {
                            "title":"Overview of Cache Groups",
                            "href":"overview-cache-groups.html#GUID-6D7C711A-5FFC-440E-9AC3-8E14B6E92D73"
                        },
                        {
                            "title":"Cache Instance",
                            "href":"cache-instance.html#GUID-A6BD7641-C8B3-4ABB-935E-2916410A3BBD"
                        },
                        {
                            "title":"Cache Group Types",
                            "href":"cache-group-types.html#GUID-6C83B5FE-5992-4F8D-8D0E-AB7616FA04E5"
                        },
                        {
                            "title":"Transmitting Changes Between the TimesTen and Oracle Databases",
                            "href":"transmitting-changes-timesten-and-oracle-databases.html#GUID-4D061A9C-A948-4DE0-97C2-83FED89B51A0"
                        },
                        {
                            "title":"Using Oracle GoldenGate as an Alternative Cache Refresh Mechanism",
                            "href":"using-oracle-goldengate-alternative-cache-refresh-mechanism.html#GUID-DCB80A6B-622E-458C-85DD-5032D2A265D6"
                        },
                        {
                            "title":"High Availability Caching Solution",
                            "href":"high-availability-caching-solution.html#GUID-C017F766-AEA2-4725-AD9F-43D3BDFF0C84"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Setting Up a Caching Infrastructure",
                    "href":"setting-caching-infrastructure.html#GUID-1562B7D8-42B4-4DC1-829E-2E4473B0C82A",
                    "topics":[
                        {
                            "title":"Configuring the Oracle Database to Cache Data",
                            "href":"configuring-oracle-database-cache-data.html#GUID-2DEBECF3-53C8-4516-B390-C2EC5D7A9811"
                        },
                        {
                            "title":"Configuring a TimesTen Database to Cache Oracle Database Data",
                            "href":"configuring-timesten-database-cache-oracle-database-data.html#GUID-750AE091-8884-497D-8C0C-5AC7B7E75725"
                        },
                        {
                            "title":"Testing the Connectivity Between the TimesTen and Oracle Databases",
                            "href":"testing-connectivity-timesten-and-oracle-databases.html#GUID-6F2E730F-B337-4771-8243-6035DAEC0771"
                        },
                        {
                            "title":"Managing the Cache Agent",
                            "href":"managing-cache-agent.html#GUID-C6BDB577-E95D-4696-96EE-7C4267539BD0"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Defining Cache Groups",
                    "href":"defining-cache-groups.html#GUID-350993AD-B4A2-4AC6-A2A8-EFF30E6FE9B8",
                    "topics":[
                        {
                            "title":"Cache Groups and Cache Tables",
                            "href":"cache-groups-and-cache-tables.html#GUID-683ECF37-5C9F-4796-AD7E-4C402A2C3D53"
                        },
                        {
                            "title":"Creating a Cache Group",
                            "href":"creating-cache-group.html#GUID-4BE2EABD-FE69-42F0-9B79-D9FF8761E8C8"
                        },
                        {
                            "title":"Read-Only Cache Group",
                            "href":"read-only-cache-group.html#GUID-5F24CCBA-057D-41C4-AFD0-7CDA03C08417"
                        },
                        {
                            "title":"Asynchronous WriteThrough (AWT) Cache Group",
                            "href":"asynchronous-writethrough-awt-cache-group.html#GUID-BEE1E0FE-36ED-4328-81AC-0E4CEE118C05"
                        },
                        {
                            "title":"Synchronous WriteThrough (SWT) Cache Group",
                            "href":"synchronous-writethrough-swt-cache-group.html#GUID-BCC1B894-365C-4273-8CAD-0F398135B54A"
                        },
                        {
                            "title":"Hybrid Cache Group",
                            "href":"hybrid-cache-group.html#GUID-0EB62361-9A75-4F7C-A852-6F64B7238F4E"
                        },
                        {
                            "title":"User Managed Cache Group",
                            "href":"user-managed-cache-group.html#GUID-DD69ECE0-0C7E-4AD5-A64F-C9C3A52ED4A4"
                        },
                        {
                            "title":"Using a WHERE Clause",
                            "href":"using-where-clause.html#GUID-023BA394-FE09-4060-800F-09E9575D4EF3"
                        },
                        {
                            "title":"Specifying Automatic Refresh With the AUTOREFRESH Cache Group Attribute",
                            "href":"specifying-automatic-refresh-autorefresh-cache-group-attribute.html#GUID-23507C35-F11E-4152-982A-26B80581DD14"
                        },
                        {
                            "title":"Creating a Dynamic Cache Group With the DYNAMIC Keyword",
                            "href":"creating-dynamic-cache-group-dynamic-keyword.html#GUID-5B469F8A-0441-468F-B4E1-7C4B2DB7E17C"
                        },
                        {
                            "title":"Creating a Hash Index on the Primary Key Columns of the Cache Table",
                            "href":"creating-hash-index-primary-key-columns-cache-table.html#GUID-844B1837-0615-46A6-A31C-C930CE42BB71"
                        },
                        {
                            "title":"ON DELETE CASCADE Cache Table Attribute",
                            "href":"delete-cascade-cache-table-attribute.html#GUID-6EB4097E-7123-48C6-A12D-67226E33D2BC"
                        },
                        {
                            "title":"Caching Oracle Database Synonyms",
                            "href":"caching-oracle-database-synonyms.html#GUID-45A3D460-4AF0-4274-AAB6-F47CD7955DF0"
                        },
                        {
                            "title":"Caching Oracle Database LOB Data",
                            "href":"caching-oracle-database-lob-data.html#GUID-CA163CBC-8BDF-49FC-9E31-F507A07C2ADE"
                        },
                        {
                            "title":"Implementing Aging in a Cache Group for TimesTen Classic",
                            "href":"implementing-aging-cache-group-timesten-classic.html#GUID-74D1AA78-DAEF-4F07-9856-33181BE1503A"
                        },
                        {
                            "title":"Replicating Cache Tables in TimesTen Classic",
                            "href":"replicating-cache-tables-timesten-classic.html#GUID-5465978E-D4ED-48CF-A55A-6298C84A4A1A"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Methods for Transmitting Changes Between TimesTen and Oracle Databases",
                    "href":"methods-transmitting-changes-timesten-and-oracle-databases.html#GUID-DB52707F-F25D-44F8-9667-C498FA746954",
                    "topics":[
                        {
                            "title":"Manually Loading and Refreshing a Cache Group",
                            "href":"manually-loading-and-refreshing-cache-group.html#GUID-F509F163-7ABA-4484-A202-E984A69B6FF0"
                        },
                        {
                            "title":"Flushing a User Managed Cache Group",
                            "href":"flushing-user-managed-cache-group.html#GUID-8F6E659A-CFB0-4CD8-811F-71BE05B67E3C"
                        },
                        {
                            "title":"Unloading a Cache Group",
                            "href":"unloading-cache-group.html#GUID-8976CB82-B667-408F-ACF6-0126EAC755AF"
                        },
                        {
                            "title":"Automatically Refreshing a Cache Group",
                            "href":"automatically-refreshing-cache-group.html#GUID-4A8B0665-E833-40CD-9DEA-044E72647C65"
                        },
                        {
                            "title":"Manually or Dynamically Loading Cache Groups",
                            "href":"manually-or-dynamically-loading-cache-groups.html#GUID-D615C07A-6D29-4962-91F8-A2EDA72E4B78"
                        },
                        {
                            "title":"Dynamic Cache Groups",
                            "href":"dynamic-cache-groups.html#GUID-5EE79774-EFF0-4B6C-95E9-871528A2F491"
                        },
                        {
                            "title":"Determining the Number of Cache Instances Affected by an Operation",
                            "href":"determining-number-cache-instances-affected-operation.html#GUID-4D708ECE-E700-4F4D-B390-6D09E573F594"
                        },
                        {
                            "title":"Setting a Passthrough Level",
                            "href":"setting-passthrough-level.html#GUID-839BE377-3450-4366-BCA7-4CF0ABDD0473"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Managing a Caching Environment",
                    "href":"managing-caching-environment.html#GUID-D1EE09AE-8C7B-4A30-805B-A48B40599149",
                    "topics":[
                        {
                            "title":"Checking the Status of Cache and Replication Agents",
                            "href":"checking-status-cache-and-replication-agents.html#GUID-1B892041-04D2-4A0A-8C02-4DE38E9E8077"
                        },
                        {
                            "title":"Cache Agent and Replication Connection Recovery",
                            "href":"cache-agent-and-replication-connection-recovery.html#GUID-87D83B59-5047-4261-8F38-C36BEFB072A3"
                        },
                        {
                            "title":"Managing a Cache Environment With Oracle Database Objects",
                            "href":"managing-cache-environment-oracle-database-objects.html#GUID-B83F9DDD-4F22-46DB-8BA1-F46176EB1EE8"
                        },
                        {
                            "title":"Monitoring Cache Groups",
                            "href":"monitoring-cache-groups.html#GUID-208C674F-FF4B-419D-B42F-996CD17D7C11"
                        },
                        {
                            "title":"Changing Cache User Names and Passwords",
                            "href":"changing-cache-user-names-and-passwords.html#GUID-B36CF813-A9B6-4C8B-AA94-DE0D1EF27DD3"
                        },
                        {
                            "title":"Dropping Oracle Database Objects Used by Cache Groups With Autorefresh",
                            "href":"dropping-oracle-database-objects-used-cache-groups-autorefresh.html#GUID-B08E262F-D21A-4D29-BE91-375BEB381433"
                        },
                        {
                            "title":"Impact on Cache Groups When Modifying the Oracle Database Schema",
                            "href":"impact-cache-groups-when-modifying-oracle-database-schema.html#GUID-6D58403A-956C-4723-AB3E-8802CBADED42"
                        },
                        {
                            "title":"Impact of Failed Autorefresh Operations on TimesTen Databases",
                            "href":"impact-failed-autorefresh-operations-timesten-databases.html#GUID-F8C569C9-CEDE-4996-9A72-F1DD19CC814F"
                        },
                        {
                            "title":"Managing the Cache Administration User's Tablespace",
                            "href":"monitoring-cache-administration-users-tablespace.html#GUID-B902691A-04C5-4BC8-9C7B-B2F9EAAB2C88"
                        },
                        {
                            "title":"Backing Up and Restoring a TimesTen Classic Database With Cache Groups",
                            "href":"backing-and-restoring-timesten-classic-database-cache-groups.html#GUID-57ADB976-274C-49A7-B7AB-D0E6DE464AF6"
                        },
                        {
                            "title":"Migrating the Oracle Database Requires Cleaning Up Cache Objects",
                            "href":"migrating-oracle-requires-removing-cache-objects.html#GUID-016E8EF2-37E3-43EF-A5F7-145420B57806"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Cache Performance",
                    "href":"cache-performance.html#GUID-3009E88F-FCF1-40FD-A075-47BB865ACA19",
                    "topics":[
                        {
                            "title":"Dynamic Load Performance",
                            "href":"dynamic-load-performance.html#GUID-F67FC932-6236-4F87-9E80-83E33640BECB"
                        },
                        {
                            "title":"Improving AWT Throughput",
                            "href":"improving-awt-throughput.html#GUID-4EEF6EBA-DACD-465C-B593-B2DF7AB18BBF"
                        },
                        {
                            "title":"Improving Performance for Autorefresh Operations",
                            "href":"improving-performance-autorefresh-operations.html#GUID-8CCE53D0-53E4-468C-9BB0-8A747C412C08"
                        },
                        {
                            "title":"Retrieving Statistics on Autorefresh Transactions",
                            "href":"retrieving-statistics-autorefresh-transactions.html#GUID-DA61B99A-7AA9-4E77-AE98-8A3F60708790"
                        },
                        {
                            "title":"Caching the Same Oracle Table on Two or More TimesTen Databases",
                            "href":"caching-same-oracle-table-two-or-more-timesten-databases.html#GUID-143D5D06-5B0C-43B7-952F-2A74DB47FBAE"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Cleaning Up the Caching Environment",
                    "href":"cleaning-caching-environment.html#GUID-F197DF9A-4CDE-421D-A617-2AFC9D374B71",
                    "topics":[
                        {
                            "title":"Stopping the Replication Agent",
                            "href":"stopping-replication-agent.html#GUID-098300A4-DB1C-4BC5-AFF5-1BD687F0BDAF"
                        },
                        {
                            "title":"Dropping a Cache Group",
                            "href":"dropping-cache-group.html#GUID-5F3DB06C-C9F5-4D4C-A191-4BAE5AFA893F"
                        },
                        {
                            "title":"Stopping the Cache Agent",
                            "href":"stopping-cache-agent.html#GUID-6B08322E-3866-4449-BEC1-5F30A4569822"
                        },
                        {
                            "title":"Destroying the TimesTen Databases",
                            "href":"destroying-timesten-databases.html#GUID-665F97B7-8996-41D6-AFAB-0FD5C44DF760"
                        },
                        {
                            "title":"Dropping Oracle Database Users and Objects",
                            "href":"dropping-oracle-database-users-and-objects.html#GUID-C9C6A624-376A-4652-9B1C-9832C58720A2"
                        },
                        {
                            "title":"Scheduling a Shutdown of Active Standby Pair With AWT Cache Groups",
                            "href":"scheduling-shutdown-active-standby-pair-awt-cache-groups.html#GUID-5CB37A68-11A8-4BE9-8E9A-998FB2D9930D"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Using Cache in an Oracle RAC Environment",
                    "href":"using-cache-oracle-rac-environment.html#GUID-988CC90E-70B2-444B-89B9-90BC78284161",
                    "topics":[
                        {
                            "title":"How Cache Works in an Oracle RAC Environment",
                            "href":"how-cache-works-oracle-rac-environment.html#GUID-94DA698D-CBD1-44CE-AA52-77B2A26B2ACC"
                        },
                        {
                            "title":"Restrictions on Using Cache in an Oracle RAC Environment",
                            "href":"restrictions-using-cache-oracle-rac-environment.html#GUID-1882AE46-9B95-4163-B7F8-6362A9FFEBFA"
                        },
                        {
                            "title":"Setting Up Cache in an Oracle RAC Environment",
                            "href":"setting-cache-oracle-rac-environment.html#GUID-EC587E20-73D2-47B6-9711-8FDC28933EB4"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Using Cache With Data Guard",
                    "href":"using-cache-data-guard.html#GUID-B2E47BA1-DE45-4C28-9B79-479AAA9B435C",
                    "topics":[
                        {
                            "title":"Components of MAA for Cache",
                            "href":"components-maa-cache.html#GUID-10A4DC45-976F-48C3-8046-5864C4E01D41"
                        },
                        {
                            "title":"Cache in TimesTen Works With Asynchronous Active Data Guard",
                            "href":"cache-works-asynchronous-active-data-guard.html#GUID-C9C50DF6-BD9C-4A27-A149-3C7388F102A8"
                        },
                        {
                            "title":"Cache in TimesTen Works With Synchronous Data Guard",
                            "href":"cache-works-synchronous-data-guard.html#GUID-CB3CA032-192B-4956-9861-D9A02F40BFB6"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> Using GoldenGate as an Alternative to Native Read-Only Cache Groups",
                    "href":"using-goldengate-alternative-native-read-only-cache-groups.html#GUID-8DAC38A7-90B3-432D-8877-76D93F43442A",
                    "topics":[
                        {
                            "title":"TimesTen and GoldenGate Support for Cache Refresh",
                            "href":"timesten-and-goldengate-support-cache-refresh.html#GUID-C86A9602-3227-43D9-B3F2-4F7700591A3C"
                        },
                        {
                            "title":"Considerations When Using GoldenGate as the Cache Refresh Mechanism",
                            "href":"considerations-when-using-goldengate-cache-refresh-mechanism.html#GUID-F2B251EB-A162-44F8-A25C-E8BCFEE7C057"
                        },
                        {
                            "title":"Configuring GoldenGate to Provide Cache Refresh Functionality for TimesTen",
                            "href":"configuring-goldengate-provide-cache-refresh-functionality-timesten.html#GUID-B24913FF-92C7-44BC-B957-2C25807974FE"
                        },
                        {
                            "title":"Example of Caching Using GoldenGate",
                            "href":"example-caching-using-goldengate.html#GUID-BA0E6680-F134-4551-9FBD-A7717960B596"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">A </span> Required Privileges for Cache Administration User for Cache Operations",
                    "href":"required-privileges-cache-operations.html"
                },
                {
                    "title":"<span class=\"secnum\">B </span> SQL*Plus Scripts for Cache",
                    "href":"sqlplus-scripts-cache.html#GUID-6013F8E2-B67E-4C2C-A49C-034053BB5257"
                },
                {
                    "title":"<span class=\"secnum\">C </span> Compatibility Between TimesTen and Oracle Databases",
                    "href":"compatibility-timesten-and-oracle-databases.html#GUID-3959D34C-E79A-433B-9225-13693992B540"
                }
            ]
        }
    ]
});