define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"About This Content",
                    "href":"this-content.html"
                },
                {
                    "title":"What's New",
                    "href":"whats-new.html#GUID-A17D6978-F39A-4910-87A0-3027D99FB621"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Overview of the Oracle TimesTen Kubernetes Operator",
                    "href":"overview-oracle-timesten-kubernetes-operator1.html#GUID-A62BE41E-7A06-4C67-BC7C-726CDB018904",
                    "topics":[
                        {
                            "title":"Overview of Containers and Kubernetes",
                            "href":"overview-containers-and-kubernetes.html#GUID-D6326A21-33B4-406D-8A03-799B621CAF21"
                        },
                        {
                            "title":"About the TimesTen Kubernetes Operator",
                            "href":"timesten-kubernetes-operator.html#GUID-D169D8A3-1A23-4BD5-ACF7-8C4440F0EE31"
                        },
                        {
                            "title":"About TimesTenClassic and TimesTenScaleout Objects",
                            "href":"timestenclassic-and-timestenscaleout-objects.html#GUID-33D5BE9F-1B2A-4AAE-A928-EA54B2ED8423"
                        },
                        {
                            "title":"About Provisioning Active Standby Pairs",
                            "href":"provisioning-active-standby-pairs.html#GUID-959CE47D-B147-4F6B-ADD3-D449CDD2EEB0"
                        },
                        {
                            "title":"About Deploying a TimesTenClassic Object",
                            "href":"deploying-timestenclassic-object.html#GUID-A7584B45-2E5F-4BC3-9B9E-FFCFDF0149A3"
                        },
                        {
                            "title":"About Deploying a TimesTen Scaleout Grid and Database",
                            "href":"deploying-timesten-scaleout-grid-and-database.html#GUID-F11567D8-5E09-4ABA-90DE-04362817B9E0"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Set Up the Environment",
                    "href":"set-environment1.html#GUID-61E964FD-9A12-40E7-8C6E-5AA02C576A62",
                    "topics":[
                        {
                            "title":"Prerequisites",
                            "href":"prerequisites.html#GUID-7282D4D7-5406-4340-B997-3F9FC53131B8"
                        },
                        {
                            "title":"About TimesTen Container Images",
                            "href":"timesten-container-images.html#GUID-5041AF31-B8A4-4858-8817-DE1330EDB79C"
                        },
                        {
                            "title":"Option 1: Use the Official TimesTen Container Images",
                            "href":"option-1-use-official-timesten-container-images.html#GUID-728FC833-F78B-4C93-91FD-5798188A01CC"
                        },
                        {
                            "title":"Option 2: Build the TimesTen Container Image",
                            "href":"option-2-build-timesten-container-image.html#GUID-98433855-7EF8-4A81-9EEC-509391A37D17"
                        },
                        {
                            "title":"About Deploying the TimesTen Operator",
                            "href":"deploying-timesten-operator.html#GUID-6EC8B749-3314-4F35-B0BC-9FA919BC6C55"
                        },
                        {
                            "title":"Create the Service Account and the TimesTen Custom Resource Definitions (CRDs)",
                            "href":"create-service-account-and-timesten-custom-resource-definitions-crds.html#GUID-97457209-92BF-4373-8D29-2811B11F004D"
                        },
                        {
                            "title":"About Readiness and Liveness Probes",
                            "href":"readiness-and-liveness-probes.html#GUID-22DB0F78-4529-46E3-9BCF-FFFC83F783B4"
                        },
                        {
                            "title":"Customize the TimesTen Operator",
                            "href":"customize-timesten-operator.html#GUID-89320F38-6EB1-46BA-9392-47B137D0A795"
                        },
                        {
                            "title":"Verify the TimesTen Operator is Running",
                            "href":"verify-timesten-operator-is-running.html#GUID-B6131F09-63CE-4CE4-B457-91999617C086"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Use Configuration Metadata",
                    "href":"use-configuration-metadata1.html#GUID-AE502E52-9FBE-4A6D-AA1F-8710672E2897",
                    "topics":[
                        {
                            "title":"Overview of Configuration Metadata and Kubernetes Facilities",
                            "href":"overview-configuration-metadata-and-kubernetes-facilities.html#GUID-2DA1AE52-8962-436C-BB79-FA81B9F85262"
                        },
                        {
                            "title":"List of Configuration Metadata",
                            "href":"list-configuration-metadata.html#GUID-0FA26D4F-878D-4BD8-AE15-E8F800AF9B7A"
                        },
                        {
                            "title":"About Configuration Metadata Details",
                            "href":"configuration-metadata-details.html#GUID-DA57B70E-496A-408E-A20B-852E470C390A"
                        },
                        {
                            "title":"Populate the /ttconfig Directory",
                            "href":"populate-ttconfig-directory.html#GUID-0B8B40F3-6F60-4AA8-9034-43415EF81A24"
                        },
                        {
                            "title":"Additional Configuration Options",
                            "href":"additional-configuration-options.html#GUID-D3886C33-7948-4188-A14A-3D1DB7121542"
                        },
                        {
                            "title":"About Readiness Probes for TimesTen Containers",
                            "href":"readiness-probes-timesten-containers.html#GUID-0FA1DB22-4CAF-4BC3-AEBC-85188ABA0797"
                        },
                        {
                            "title":"About /tmp/active Readiness Probes",
                            "href":"tmp-active-readiness-probes.html#GUID-2CC99D5A-486D-4F07-815A-F398D9856328"
                        },
                        {
                            "title":"About /tmp/readiness Readiness Probes",
                            "href":"tmp-readiness-readiness-probes.html#GUID-7B9297AF-5838-49E3-A19F-948B68879766"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Specify CPU and Memory Requests and Limits",
                    "href":"specify-cpu-and-memory-requests-and-limits1.html#GUID-90CB3F72-BA94-4CD5-ACF4-48A368331AAA",
                    "topics":[
                        {
                            "title":"About Resource Requests and Limits",
                            "href":"resource-requests-and-limits.html#GUID-ECD60B94-30CC-40FB-BDAD-CC6D169C1A35"
                        },
                        {
                            "title":"About TimesTen Containerized Deployments",
                            "href":"timesten-containerized-deployments.html#GUID-C25AF688-7EAA-4D38-8801-F3985AAAC5A2"
                        },
                        {
                            "title":"About Specifying Requests and Limits for TimesTen Containers",
                            "href":"specifying-requests-and-limits-timesten-containers.html#GUID-D752B366-43B3-4C7E-900C-E091D999F862"
                        },
                        {
                            "title":"Approach 1: Use Specific Datum for Requests and Limits",
                            "href":"approach-1-use-specific-datum-requests-and-limits.html#GUID-83A6142C-8B8C-4601-86D5-A25FC77DC9CE"
                        },
                        {
                            "title":"Approach 2: Use Templates for Requests and Limits",
                            "href":"approach-2-use-templates-requests-and-limits.html#GUID-B9BCA7E7-ECBE-448A-B792-CB8D61E68D99"
                        },
                        {
                            "title":"About Specifying Requests and Limits to Kubernetes",
                            "href":"specifying-requests-and-limits-kubernetes.html#GUID-72C82AEA-3AA9-4B2A-A286-816D44C3E8B2"
                        },
                        {
                            "title":"About Verifying databaseMemorySize",
                            "href":"verifying-databasememorysize.html#GUID-219351A8-64CD-40F8-B484-22FE31061AFB"
                        },
                        {
                            "title":"About Runtime Memory Monitoring",
                            "href":"runtime-memory-monitoring.html#GUID-20A7B49F-927D-4B50-8344-C081D9035F1E"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Deploy TimesTen Classic Databases",
                    "href":"deploy-timesten-classic-databases1.html#GUID-67A96CD3-EA73-4990-B285-D300C92F6917",
                    "topics":[
                        {
                            "title":"About the Deployment Process",
                            "href":"deployment-process.html#GUID-EB57C745-9732-437C-B306-24236FF0C4E6"
                        },
                        {
                            "title":"Define and Create a TimesTenClassic Object",
                            "href":"define-and-create-timestenclassic-object.html#GUID-C154039B-1E47-4E39-9C31-2D58C93FD163"
                        },
                        {
                            "title":"Monitor Progress of an Active Standby Pair Deployment",
                            "href":"monitor-progress-active-standby-pair-deployment.html#GUID-284DADF5-7F90-4029-8C0E-C94F9A75FD68"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Deploy TimesTen Scaleout Databases",
                    "href":"deploy-timesten-scaleout-databases1.html#GUID-FBA2DA64-2EE6-42F3-B8E7-FD703A2D6EE9",
                    "topics":[
                        {
                            "title":"About Deploying a Grid",
                            "href":"deploying-grid.html#GUID-2C5CB7E6-8249-411B-BCD9-3A729C2659AC"
                        },
                        {
                            "title":"Deploy a Grid",
                            "href":"deploy-grid.html#GUID-F77B42F4-15F7-4768-B970-34681EE8BB33"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Use Helm to Deploy the TimesTen Kubernetes Operator and TimesTenClassic Objects",
                    "href":"use-helm-deploy-timesten-kubernetes-operator-and-timestenclassic-objects1.html#GUID-0C2B358C-DCA1-4AD3-8AC0-CFBB769F49BE",
                    "topics":[
                        {
                            "title":"Overview of Helm",
                            "href":"overview-helm.html#GUID-081BADAA-3706-408A-B892-55B20F33FFC1"
                        },
                        {
                            "title":"About a Helm Chart",
                            "href":"helm-chart.html#GUID-FA18A752-25E2-4861-958D-BAB19EEC7CFE"
                        },
                        {
                            "title":"About Helm Charts for TimesTen",
                            "href":"helm-charts-timesten.html#GUID-28E74C66-495D-45BB-BEBF-289C98500F29"
                        },
                        {
                            "title":"About Versions in a Chart.yaml File",
                            "href":"versions-chart-yaml-file.html#GUID-5403A209-AD94-401D-BB11-336C96FEF992"
                        },
                        {
                            "title":"About the Helm Substitution Engine and Language",
                            "href":"helm-substitution-engine-and-language.html#GUID-B0C4CF92-08E2-4C0E-9BF4-A392213F3D71"
                        },
                        {
                            "title":"About Installing and Testing a Release",
                            "href":"installing-and-testing-release.html#GUID-D8DE3BE8-CEA5-421A-8DA9-BF2AB5BB392B"
                        },
                        {
                            "title":"Install the TimesTen Custom Resource Definitions (CRDs)",
                            "href":"install-timesten-custom-resource-definitions-crds.html#GUID-1DA7B5DE-92DB-47D3-80AD-957C861BEC29"
                        },
                        {
                            "title":"Install the TimesTen Operator",
                            "href":"install-timesten-operator.html#GUID-32CE1DD0-0364-4499-96B4-587DC02EE163"
                        },
                        {
                            "title":"Test the TimesTen Operator",
                            "href":"test-timesten-operator.html#GUID-8BCC09D4-E506-47A1-BE32-93E4EBE01525"
                        },
                        {
                            "title":"Install TimesTen Databases",
                            "href":"install-timesten-databases.html#GUID-CD00CD63-EDC5-4191-9DC0-FEDFCD961B54"
                        },
                        {
                            "title":"Test TimesTen",
                            "href":"test-timesten.html#GUID-F5C5EF94-8099-4516-B0EC-7AF005355E19"
                        },
                        {
                            "title":"Upgrade the TimesTen Custom Resource Definitions (CRDs)",
                            "href":"upgrade-timesten-custom-resource-definitions-crds.html#GUID-45A19F74-F3F7-4202-A0C8-654198D20407"
                        },
                        {
                            "title":"Upgrade the TimesTen Operator",
                            "href":"upgrade-timesten-operator.html#GUID-D5D54E4E-02C0-425A-ACDE-40B55167F0F2"
                        },
                        {
                            "title":"Upgrade TimesTen",
                            "href":"upgrade-timesten.html#GUID-05C65131-52C1-478B-A4F8-51F2D3BD50DB"
                        },
                        {
                            "title":"Roll Back a TimesTen Upgrade",
                            "href":"roll-back-timesten-upgrade.html#GUID-504B2919-37E6-43C2-A5E4-A4A7087A96F1"
                        },
                        {
                            "title":"Roll Back a TimesTen Operator Upgrade",
                            "href":"roll-back-timesten-operator-upgrade.html#GUID-F3B22C67-9F44-4E03-BCFD-4076D8F681AD"
                        },
                        {
                            "title":"Roll Back a TimesTen Custom Resource Definitions (CRDs) Upgrade",
                            "href":"roll-back-timesten-custom-resource-definitions-crds-upgrade.html#GUID-F37BAE7A-E48A-4438-95B5-BBEFD21A35B7"
                        },
                        {
                            "title":"About Uninstalling a Release",
                            "href":"uninstalling-release.html#GUID-5D65CEAF-F021-4ECF-BD1D-8273C5FD5766"
                        },
                        {
                            "title":"Delete TimesTen Databases",
                            "href":"delete-timesten-databases.html#GUID-8B85E827-A999-417D-B942-5B7A73EF6D42"
                        },
                        {
                            "title":"Delete the TimesTen Operator",
                            "href":"delete-timesten-operator.html#GUID-E4A0BF1F-11C0-4D07-A0A5-FDB8E33F8F4D"
                        },
                        {
                            "title":"Delete the TimesTen Custom Resource Definitions (CRDs)",
                            "href":"delete-timesten-custom-resource-definitions-crds.html#GUID-0A7587A0-22F9-498D-AE2C-80C66FBA0E5D"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Use TimesTen Databases",
                    "href":"use-timesten-databases1.html#GUID-A39F2586-913F-4EAB-9AC6-869581B89B33",
                    "topics":[
                        {
                            "title":"About Using Direct Mode Applications",
                            "href":"using-direct-mode-applications.html#GUID-E57C8471-AB0B-4150-ADCD-C7DD48ED406C"
                        },
                        {
                            "title":"About Using Client/Server Drivers",
                            "href":"using-client-server-drivers.html#GUID-42752C52-D1A4-42DE-B09E-5491CBF092D2"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Manage and Monitor Active Standby Pairs",
                    "href":"manage-and-monitor-active-standby-pairs1.html#GUID-346D215C-D993-44E4-B876-42DB81CD6851",
                    "topics":[
                        {
                            "title":"About Monitoring the Health of Each Pod in an Active Standby Pair",
                            "href":"monitoring-health-each-pod-active-standby-pair.html#GUID-01C10EF6-CAB0-4A9D-8ADD-15CD00C41E9A"
                        },
                        {
                            "title":"About Monitoring the Health of an Active Standby Pair of Databases",
                            "href":"monitoring-health-active-standby-pair-databases.html#GUID-292FC4AC-1331-47D7-9BB9-7A4B30041AE3"
                        },
                        {
                            "title":"About the BothDown State",
                            "href":"bothdown-state.html#GUID-C537D365-DF10-433C-B115-FDE2DEDD8737"
                        },
                        {
                            "title":"About the ManualInterventionRequired State",
                            "href":"manualinterventionrequired-state1.html#GUID-EF9829CF-750A-4695-B091-189C64D73231"
                        },
                        {
                            "title":"About Bringing Up One Database",
                            "href":"bringing-one-database.html#GUID-5D606D43-F3F6-451F-BE8C-FAAA62960244"
                        },
                        {
                            "title":"Suspend Management of a TimesTenClassic Object",
                            "href":"suspend-management-timestenclassic-object.html#GUID-074124A5-F6D3-4A00-85E1-30B1FEFAA951"
                        },
                        {
                            "title":"Locate the Operator",
                            "href":"locate-operator.html#GUID-83E3D052-33A8-4373-B98E-2B9B832876E8"
                        },
                        {
                            "title":"Manage the TimesTen Databases",
                            "href":"manage-timesten-databases.html#GUID-173354FD-792A-4271-84D8-BBFA6BF97423"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Manage TimesTen Scaleout",
                    "href":"manage-timesten-scaleout1.html#GUID-39F6B3CF-2FCA-449E-9DD2-39687C9318FC",
                    "topics":[
                        {
                            "title":"About Managing TimesTen Scaleout",
                            "href":"managing-timesten-scaleout.html#GUID-E093137E-7375-420C-B379-C0E374B71142"
                        },
                        {
                            "title":"About Single Data Instance Failure",
                            "href":"single-data-instance-failure.html#GUID-B89CA3AF-889B-4BE7-8AD5-95FF207C45F7"
                        },
                        {
                            "title":"About Management Instance Failure",
                            "href":"management-instance-failure.html#GUID-8422F23E-0C8E-4909-8438-711E9386B88A"
                        },
                        {
                            "title":"About the waiting for seed State",
                            "href":"waiting-seed-state.html#GUID-631D6C8E-6BDF-4307-A052-0B290BC169F9"
                        },
                        {
                            "title":"About Failure of All Data Instances",
                            "href":"failure-all-data-instances.html#GUID-766A8479-8E83-489F-896B-7D0A755C0F3D"
                        },
                        {
                            "title":"About High Level States",
                            "href":"high-level-states.html#GUID-38DB87CA-A75F-4F78-B0CB-9DAFC7DAC957"
                        },
                        {
                            "title":"About Management States",
                            "href":"management-states.html#GUID-69FC394D-B201-4F32-AE14-2C0EC9CABCCF"
                        },
                        {
                            "title":"About Database and Element States",
                            "href":"database-and-element-states.html#GUID-98CEAC08-8BA4-4B10-BBD6-D0DA5D66C660"
                        },
                        {
                            "title":"About the ManualInterventionRequired State",
                            "href":"manualinterventionrequired-state.html#GUID-7B25EE5E-2504-4099-ACC9-E1EA007D625C"
                        },
                        {
                            "title":"About Suspending Management",
                            "href":"suspending-management1.html#GUID-F0547069-F0F9-4D79-96FB-E73B7FAA3BDC"
                        },
                        {
                            "title":"Simulate Single Data Instance Failure",
                            "href":"simulate-single-data-instance-failure.html#GUID-DBC3DD86-CB7A-4531-A295-4DBEFCBC5D57"
                        },
                        {
                            "title":"Simulate Management Instance Failure",
                            "href":"simulate-management-instance-failure.html#GUID-58F08116-B4E9-45FD-BBA0-0680D3E12BF4"
                        },
                        {
                            "title":"Simulate Replica Set Failure with Restart",
                            "href":"simulate-replica-set-failure-restart.html#GUID-9F549E34-A902-48E8-AB8F-2A900F73854A"
                        },
                        {
                            "title":"Simulate Replica Set Failure with Manual",
                            "href":"simulate-replica-set-failure-manual.html#GUID-0950D905-A77D-4661-9BDE-558C9723A963"
                        },
                        {
                            "title":"Suspend Management",
                            "href":"suspend-management.html#GUID-0F931FDA-BDFD-4278-821B-5ADFFA3E3028"
                        },
                        {
                            "title":"Set reexamine Datum",
                            "href":"set-reexamine-datum.html#GUID-70CD1360-FFF6-40B0-982F-2AE36A19B604"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> Expose TimesTen Metrics with the TimesTen Kubernetes Operator",
                    "href":"expose-timesten-metrics-timesten-kubernetes-operator1.html#GUID-9FBCDA56-A9E7-4CC9-9458-B76B40FF605E",
                    "topics":[
                        {
                            "title":"Overview of TimesTen Metrics",
                            "href":"overview-timesten-metrics.html#GUID-93CB4F52-831E-487D-8205-8C70ED253F79"
                        },
                        {
                            "title":"Overview of the TimesTen Kubernetes Operator and the TimesTen Exporter",
                            "href":"overview-timesten-kubernetes-operator-and-timesten-exporter.html#GUID-9B52E296-127A-4A7D-AF28-364547881908"
                        },
                        {
                            "title":"About the Prometheus Operator",
                            "href":"prometheus-operator.html#GUID-A6029AE3-BE80-4D0B-B3C7-599F937F148D"
                        },
                        {
                            "title":"About Exposing TimesTen Metrics",
                            "href":"exposing-timesten-metrics.html#GUID-7F788D52-D1FD-44D8-9C2C-BFE208E5CC58"
                        },
                        {
                            "title":"About Using http or https for TimesTen Metrics",
                            "href":"using-http-or-https-timesten-metrics.html#GUID-CC14B471-B59C-42F3-8C96-745C2C11E722"
                        },
                        {
                            "title":"About Transport Layer Security (mutual TLS) Certificates for TimesTen Metrics",
                            "href":"transport-layer-security-mutual-tls-certificates-timesten-metrics.html#GUID-67F48D9A-4B99-42DF-97AA-24ABD47DF6CF"
                        },
                        {
                            "title":"About Creating PodMonitor Objects",
                            "href":"creating-podmonitor-objects.html#GUID-8C054AF4-6B28-445F-9DF3-7D89C614CA40"
                        },
                        {
                            "title":"About the TimesTen Metrics Service",
                            "href":"timesten-metrics-service.html#GUID-1E0E38F9-53A6-4DDE-BACE-6F5370297BA5"
                        },
                        {
                            "title":"About Choosing to Expose TimesTen Metrics",
                            "href":"choosing-expose-timesten-metrics.html#GUID-C4C90746-B029-491B-8282-0CBE0E2EFBFB"
                        },
                        {
                            "title":"Expose TimesTen Metrics Automatically",
                            "href":"expose-timesten-metrics-automatically.html#GUID-65965F8A-514E-4DA2-9F0D-7727E782B0FF"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">12 </span> Expose Metrics from the TimesTen Kubernetes Operator",
                    "href":"expose-metrics-timesten-kubernetes-operator1.html#GUID-EDF1F718-2123-4F04-9507-8D4E788173E8",
                    "topics":[
                        {
                            "title":"About Exposing Metrics from the TimesTen Kubernetes Operator",
                            "href":"exposing-metrics-timesten-kubernetes-operator.html#GUID-89F96A7C-7933-4B47-B1D9-DC433E346C72"
                        },
                        {
                            "title":"About Using http or https",
                            "href":"using-http-or-https.html#GUID-CAC356C9-CEAD-4147-AB2B-B076A0040993"
                        },
                        {
                            "title":"About Transport Layer Security (mutual TLS) Certificates",
                            "href":"transport-layer-security-mutual-tls-certificates.html#GUID-8FF7B8A6-A015-4524-881A-837E916D50A5"
                        },
                        {
                            "title":"About Creating ServiceMonitor Objects",
                            "href":"creating-servicemonitor-objects.html#GUID-52005ABD-8EF6-4C19-A07F-595701055435"
                        },
                        {
                            "title":"About the TimesTen Kubernetes Operator's Metrics Service",
                            "href":"timesten-kubernetes-operators-metrics-service.html#GUID-FB42B404-B4BA-4139-ADC6-8E4BB381ACFD"
                        },
                        {
                            "title":"About TimesTen Operator Metrics",
                            "href":"timesten-operator-metrics.html#GUID-32602575-3DEE-42D2-BC41-26D725480B15"
                        },
                        {
                            "title":"Demonstrate How to Expose TimesTen Kubernetes Operator Metrics",
                            "href":"demonstrate-how-expose-timesten-kubernetes-operator-metrics.html#GUID-FBB153BD-F5F7-4AA5-A187-F123584422C7"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">13 </span> Work with TimesTen Cache",
                    "href":"work-timesten-cache1.html#GUID-6ADC0F88-65B2-4EA9-9A3A-6ECDA353C14D"
                },
                {
                    "title":"<span class=\"secnum\">14 </span> Use Encryption for Data Transmission",
                    "href":"use-encryption-data-transmission1.html#GUID-3F3BAA44-AA5F-4E2B-BF7F-D63BA779A757",
                    "topics":[
                        {
                            "title":"Create TLS Certificates for Replication and Client/Server",
                            "href":"create-tls-certificates-replication-and-client-server.html#GUID-D0EC1F44-8CA3-46EB-BEBE-D96F9F4E3749"
                        },
                        {
                            "title":"Configure TLS for Replication",
                            "href":"configure-tls-replication.html#GUID-59A8E9F0-667B-4B0F-A79A-40B3B43AD059"
                        },
                        {
                            "title":"Configure TLS for Client/Server",
                            "href":"configure-tls-client-server.html#GUID-20BD0ACE-4DCF-4B25-8E7D-7670D4B12B7F"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">15 </span> Handle Failover and Recovery in TimesTen Classic",
                    "href":"handle-failover-and-recovery-timesten-classic1.html#GUID-998BA5D0-A64D-4E23-AA32-A41F9AC5B9FF",
                    "topics":[
                        {
                            "title":"About Handling Failover and Recovery",
                            "href":"handling-failover-and-recovery.html#GUID-17A2FA21-A612-41AB-92B1-88A478405ADB"
                        },
                        {
                            "title":"Illustrate the Failover and Recovery Process",
                            "href":"illustrate-failover-and-recovery-process.html#GUID-5CCDF57D-EFC8-4328-BADE-F3F4C02782DC"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">16 </span> Perform Upgrades",
                    "href":"perform-upgrades1.html#GUID-8F6C2F5B-758F-4469-9B18-B8F61BCBAADE",
                    "topics":[
                        {
                            "title":"About New TimesTen Container Images",
                            "href":"new-timesten-container-images.html#GUID-41205C78-88C7-4C2D-BA85-5E18E1226ABC"
                        },
                        {
                            "title":"Upgrade the Operator",
                            "href":"upgrade-operator.html#GUID-A14F6338-1D19-4AB6-962C-836778EEBD5B"
                        },
                        {
                            "title":"About Upgrading TimesTen Classic",
                            "href":"upgrading-timesten-classic.html#GUID-9F41A23D-90E6-4ED1-9C2D-51B0BB1E39FF"
                        },
                        {
                            "title":"Perform an Automated Upgrade",
                            "href":"perform-automated-upgrade.html#GUID-5A9217A0-0520-4AC4-993A-8B5EE7675E7F"
                        },
                        {
                            "title":"Perform a Manual Upgrade",
                            "href":"perform-manual-upgrade.html#GUID-18CC8262-166A-4BD4-9E39-72267B8EC59F"
                        },
                        {
                            "title":"Verify the Active Standby Pair of Databases Are Upgraded",
                            "href":"verify-active-standby-pair-databases-are-upgraded.html#GUID-9DF91C6A-07F6-4A5E-A29B-0F9B2A509A39"
                        },
                        {
                            "title":"About Upgrading Direct Mode Applications",
                            "href":"upgrading-direct-mode-applications.html#GUID-4B911A66-B6C8-4405-86FE-25BEF9C09B20"
                        },
                        {
                            "title":"About Failures During an Upgrade",
                            "href":"failures-upgrade.html#GUID-B16B01DD-E6F9-4088-8C91-8E662AF8D938"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">17 </span> The TimesTen Kubernetes Operator Object Types",
                    "href":"timesten-kubernetes-operator-object-types1.html#GUID-B63B95B2-665B-4B38-B823-0ADBD54BE5BF",
                    "topics":[
                        {
                            "title":"Overview of the TimesTen Kubernetes Operator Object Types",
                            "href":"overview-timesten-kubernetes-operator-object-types.html#GUID-C75A0C1A-667F-4343-970F-9FB50586293A"
                        },
                        {
                            "title":"About the TimesTenClassic Object Type",
                            "href":"timestenclassic-object-type.html#GUID-9272EA9B-D85B-4759-916B-17CA2547F5D8"
                        },
                        {
                            "title":"TimesTenClassic",
                            "href":"timestenclassic.html#GUID-DDB867D4-9478-45DF-BB97-A0E4C524AE34"
                        },
                        {
                            "title":"TimesTenClassicSpec",
                            "href":"timestenclassicspec.html#GUID-C03B7B01-9DF3-43C9-9881-46C1BBAAEC9C"
                        },
                        {
                            "title":"TimesTenClassicSpecSpec",
                            "href":"timestenclassicspecspec.html#GUID-5CEC1DB9-E040-49E7-99C1-8771EB870BEA"
                        },
                        {
                            "title":"TimesTenClassicSpecSpecPrometheus",
                            "href":"timestenclassicspecspecprometheus.html#GUID-05CE7840-8721-49A6-A430-3E229D58DA96"
                        },
                        {
                            "title":"TimesTenClassicStatus",
                            "href":"timestenclassicstatus.html#GUID-5828E900-8D39-4DFE-8102-040788400A3E"
                        },
                        {
                            "title":"About the TimesTenScaleout Object Type",
                            "href":"timestenscaleout-object-type.html#GUID-598E0B36-FFAB-4AC2-86EC-54160FDE7B4A"
                        },
                        {
                            "title":"TimesTen Scaleout",
                            "href":"timestenscaleout.html#GUID-4AD3BBA1-5768-462F-AF9B-990D4E680782"
                        },
                        {
                            "title":"TimesTenScaleoutSpec",
                            "href":"timestenscaleoutspec.html#GUID-C6F21CF5-ECB5-4F8E-BD81-7BA5595C0B99"
                        },
                        {
                            "title":"TimesTenScaleoutSpecSpec",
                            "href":"timestenscaleoutspecspec.html#GUID-5630772D-D030-4806-BC9B-A577ED086BA9"
                        },
                        {
                            "title":"TimesTenScaleoutSpecSpecPrometheus",
                            "href":"timestenscaleoutspecspecprometheus.html#GUID-07A0F7ED-76C8-4DE9-8A23-A076E92512D9"
                        },
                        {
                            "title":"TimesTenScaleoutStatus",
                            "href":"timestenscaleoutstatus.html#GUID-2D5C8E50-75D8-495D-84F8-F59649692E4F"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">18 </span> Helm Charts for the TimesTen Kubernetes Operator",
                    "href":"helm-charts-timesten-kubernetes-operator1.html#GUID-A0B6594A-E350-4AE2-8579-C8D3A2FD873E",
                    "topics":[
                        {
                            "title":"The ttoperator Chart",
                            "href":"ttoperator-chart.html#GUID-285DC5B1-324D-4CF0-9737-E30F28272A81"
                        },
                        {
                            "title":"The ttclassic Chart",
                            "href":"ttclassic-chart.html#GUID-C6436CC4-FBF0-4C8B-8CD9-30657175C0E0"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">19 </span> TimesTen Kubernetes Operator Metrics",
                    "href":"timesten-kubernetes-operator-metrics1.html#GUID-A030506A-FED4-4E69-B29F-6F727C03B1CD"
                },
                {
                    "title":"<span class=\"secnum\">20 </span> TimesTen Kubernetes Operator Environment Variables",
                    "href":"timesten-kubernetes-operator-environment-variables1.html#GUID-EA9E1459-A0F7-452A-B5AF-B8BA96E5B507"
                },
                {
                    "title":"<span class=\"secnum\">21 </span> Dockerfile ARGs",
                    "href":"dockerfile-args1.html#GUID-6E3E1AF6-4217-43D9-AA88-694C1CDAC38A"
                },
                {
                    "title":"<span class=\"secnum\">A </span> Active Standby Pair Example",
                    "href":"active-standby-pair-example1.html#GUID-627C57AB-69C7-4BBA-A855-765940618947",
                    "topics":[
                        {
                            "title":"Create a ConfigMap Object",
                            "href":"create-configmap-object.html#GUID-0C85BE3E-E46E-4B7F-86DD-C93E7D89B4DE"
                        },
                        {
                            "title":"Create a TimesTenClassic Object",
                            "href":"create-timestenclassic-object.html#GUID-18CC9241-C741-45E6-8402-93B15AFF836E"
                        },
                        {
                            "title":"Monitor Deployment",
                            "href":"monitor-deployment.html#GUID-6F48390E-FDD6-40F0-9ACA-0BF353F43A4C"
                        },
                        {
                            "title":"Verify Existence of Underlying Objects",
                            "href":"verify-existence-underlying-objects.html#GUID-18F346C2-F59C-470C-BC51-91C156D3530B"
                        },
                        {
                            "title":"Verify Connection to the Active TimesTen Database",
                            "href":"verify-connection-active-timesten-database.html#GUID-295B93FD-A6EF-4525-BD46-2E88DEB95A28"
                        },
                        {
                            "title":"Recover from Failure",
                            "href":"recover-failure.html#GUID-DCC43072-A281-4E09-9044-0203D1EDD6EB"
                        },
                        {
                            "title":"Clean Up",
                            "href":"clean.html#GUID-78CB13BE-51FB-4049-A430-3FCC36D77F5D"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">B </span> TimesTen Cache in TimesTen Classic Example",
                    "href":"timesten-cache-timesten-classic-example1.html#GUID-9D787EDD-44E4-4667-B227-929E50B3F980",
                    "topics":[
                        {
                            "title":"Set Up the Oracle Database to Cache Data",
                            "href":"set-oracle-database-cache-data.html#GUID-7F580645-3A05-4114-8C68-7301C34D794B"
                        },
                        {
                            "title":"Create Metadata Files and a Kubernetes Facility",
                            "href":"create-metadata-files-and-kubernetes-facility.html#GUID-1C9B189A-92A9-4CFF-8A79-72DD036B8F83"
                        },
                        {
                            "title":"Create a TimesTenClassic Object",
                            "href":"create-timestenclassic-object2.html#GUID-46E4789D-B3A1-4E45-B87E-E6DB9C597A09"
                        },
                        {
                            "title":"Monitor Deployment of a TimesTenClassic Object",
                            "href":"monitor-deployment-timestenclassic-object1.html#GUID-BF979146-2AD8-4F52-BBAB-07EEDC1B1535"
                        },
                        {
                            "title":"Verify TimesTen Cache Configuration",
                            "href":"verify-timesten-cache-configuration1.html#GUID-F5398FF2-242D-43E9-87EF-3BEAE37A886E"
                        },
                        {
                            "title":"Perform Operations On Cache Group Tables",
                            "href":"perform-operations-cache-group-tables.html#GUID-C9E05F13-97FF-4264-BEE5-4EA51BEEA707"
                        },
                        {
                            "title":"Clean Up Cache Metadata on the Oracle Database",
                            "href":"clean-cache-metadata-oracle-database1.html#GUID-E68FCD71-48B5-42EA-BB50-CF446AA1D308"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">C </span> TimesTen Cache in TimesTen Scaleout Example",
                    "href":"timesten-cache-timesten-scaleout-example1.html#GUID-27C640B8-2988-4599-A26B-1B9E39E4F8DF",
                    "topics":[
                        {
                            "title":"Set Up the Oracle Database to Cache Data",
                            "href":"set-oracle-database-cache-data1.html#GUID-BF6F7560-D20B-44C7-A7E7-3AE5C981FCA9"
                        },
                        {
                            "title":"Create Metadata Files and a Kubernetes Facility",
                            "href":"create-metadata-files-and-kubernetes-facility1.html#GUID-CB0147D7-8DC9-4C1B-9AB4-04951ED96005"
                        },
                        {
                            "title":"Create a TimesTenScaleout Object",
                            "href":"create-timestenscaleout-object.html#GUID-0B70064B-657D-48CB-9080-7D11B7632ACA"
                        },
                        {
                            "title":"Monitor Deployment of a TimesTenScaleout Object",
                            "href":"monitor-deployment-timestenscaleout-object.html#GUID-2400FB3C-8002-4FD1-913C-2A88DB42533C"
                        },
                        {
                            "title":"Verify TimesTen Cache Configuration",
                            "href":"verify-timesten-cache-configuration.html#GUID-6212385D-666B-4326-8189-0DFF5D1468AF"
                        },
                        {
                            "title":"Perform Operations on the oratt_grid.readtab Table",
                            "href":"perform-operations-oratt_grid-readtab-table.html#GUID-ACDA19E2-4B24-4685-A0DC-4463DEC84D39"
                        },
                        {
                            "title":"Clean Up Cache Metadata on the Oracle Database",
                            "href":"clean-cache-metadata-oracle-database.html#GUID-A40AC3A9-F8E6-4576-902D-5572475B7F17"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">D </span> Create Your Own Oracle Wallet, Certificates, and Secrets for Exposing TimesTen Metrics",
                    "href":"create-your-own-oracle-wallet-certificates-and-secrets-exposing-timesten-metrics1.html#GUID-35081AAC-D731-45A1-8561-BABD384FD1BE",
                    "topics":[
                        {
                            "title":"About Creating Your Own Oracle Wallet, Certificates, and Kubernetes Secrets",
                            "href":"creating-your-own-oracle-wallet-certificates-and-kubernetes-secrets.html#GUID-F5C7937D-5DA9-4E3C-A439-E7B838DE6FF0"
                        },
                        {
                            "title":"Create Your Own Oracle Wallet, Certificates, and Kubernetes Secrets",
                            "href":"create-your-own-oracle-wallet-certificates-and-kubernetes-secrets.html#GUID-1C0D9A19-44D7-4DEC-A760-74375919FF06"
                        }
                    ]
                }
            ]
        }
    ]
});