package com.example.fn;

import java.util.Map;
import java.util.HashMap;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class HelloFunction {

    public Result handleRequest(Input input) {
        Result result = new Result();

        String token = input.data.get("token");
        String customer = input.data.get("customer");
        String customerKey = System.getenv("FN_" + customer + "_KEY");
        
        if (token.equals(customerKey)) {
            result.active = true;
            result.expiresAt = formatUsingDateTimeFormatter(60);
            
            String[] scopes = {"list:hello", "create:hello", "delete:hello"};
            result.scope = scopes;

            result.context = new HashMap<String, Object>();
            result.context.put("valor01", "teste01");
            result.context.put("valor02", "teste02");

        } else {
            result.active = false;
            result.wwwAuthenticate = "Token validation failed";
        }

        return result;
    }

    public static class Input {
        public String type;
        public Map<String, String> data;
    }


    public static class Result {
        // required
        public boolean active = false;
        public String principal;
        public String[] scope;
        public String expiresAt;

        // optional
        public String wwwAuthenticate;

        // optional
        public String clientId;

        // optional context
        public Map<String, Object> context;
    }

    public static String formatUsingDateTimeFormatter(long minutes) {
        LocalDateTime now = LocalDateTime.now().plusMinutes(minutes);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        String formattedDate = now.atOffset(ZoneOffset.UTC).format(formatter);
        return formattedDate;
    }    

}