###################################################################################
# OKE Advanced Terraform Root Module: File: ~/oke_advanced_module/provider.tf     #
#                                                                                 #
# Description:                                                                    #
#   Provider config for OKE advanced root module—Local, CI/CD, or automation.     #
#   Passes all required OCI authentication variables explicitly. Use this file    #
#   when running Terraform outside of Oracle Resource Manager (ORM).              #
#                                                                                 #
#   Best Practices:                                                               #
#     - Never check secrets/keys into version control.                            #
#     - Store secrets such as API keys securely - never hard-code in codebase.    #
#     - Use environment variables or vault for sensitive variables.               #
#     - Pin all provider versions and validate against OCI docs.                  #
#     - Pin provider versions for consistency and reproducibility.                #
#     - Use the latest tested stable Terraform version in your enterprise.        #
#     - Review OCI/Kubernetes provider release notes before upgrading versions.   #
#     - Regularly update provider and Terraform versions for security/feature     #
#       enhancements, but validate with your internal policies and dependencies.  #
#     - Configure workspaces for environment isolation if managing multiple       #
#       environments.                                                             #
#                                                                                 #
# Authors: Mahamat H. Guiagoussou, Payal Sharma, Matthew McDaniel                 #
# Copyright (c) 2025 Oracle                                                       #
###################################################################################


#-------------------------------#
# Terraform Version & Providers #
#-------------------------------#

terraform {
  # Ensures compatibility with all modules. 1.6.0+ recommended (Jun 2024).
  required_version = ">= 1.6.0"

  required_providers {
    # Oracle Cloud Infrastructure provider for managing Oracle resources.
    oci = {
      source  = "oracle/oci"
      version = ">= 7.21.0"
      # See https://registry.terraform.io/providers/oracle/oci/latest
      # For production, use the latest stable version as supported by OCI docs.
    }

    # HashiCorp Kubernetes provider for interacting with Kubernetes resources.
    kubernetes = {
      source = "hashicorp/kubernetes"
      # No version is specified here; consider pinning for reproducibility.
      # See https://registry.terraform.io/providers/hashicorp/kubernetes/latest
    }
  }
}


#--------------------------------------------#
# OCI Provider Configuration (Terraform CLI) #
#--------------------------------------------#

# Authenticates Terraform with Oracle Cloud Infrastructure (OCI),
# Explicit authentication for local/automation.
provider "oci" {
  user_ocid        = var.user_ocid        # IAM User OCID for API authentication
  fingerprint      = var.fingerprint      # API key fingerprint
  private_key_path = var.private_key_path # Path to API signing key
  tenancy_ocid     = var.tenancy_ocid     # Target tenancy OCID
  region           = var.region           # OCI region for resource management
}
