##################################################################################
# OKE Advanced Terraform Root Module: File: ~/oke_advanced_module/outputs.tf     #
#                                                                                #
# Description:                                                                   #
#   Output definitions for Oracle Kubernetes Engine (OKE) advanced root module.  #
#   Exposes resource OCIDs, names, and IPs for VCN, OKE, Bastion, and NodePools. #
#                                                                                #
# Authors: Mahamat H. Guiagoussou, Payal Sharma, Matthew McDaniel                #
# Copyright (c) 2025 Oracle                                                      #
##################################################################################


#-------------------------------#
# VCN Network Outputs           #
#-------------------------------#

# The OCID of the Virtual Cloud Network (VCN)
output "vcn_id" {
  description = "The OCID of the VCN."
  value       = var.is_vcn_created ? module.vcn[0].vcn_id : null
}


# The display name of the VCN
output "vcn_name" {
  description = "The display name of the VCN."
  value       = var.is_vcn_created ? module.vcn[0].vcn_name : null
}



#-------------------------------#
# Bastion Host Outputs          #
#-------------------------------#


# Public IP addresses of the bastion host(s)
output "bastion_public_ips" {
  description = "Public IP addresses of the bastion host(s)."
  value       = var.is_bastion_created ? module.bastion[0].bastion_public_ips.this_bastion : null
}


# Display name of the bastion host(s)
output "bastion_display_name" {
  description = "Display name of the bastion host(s)."
  value       = var.is_bastion_created ? module.bastion[0].bastion_display_name.this_bastion : null
}


#-------------------------------#
# OKE Cluster Outputs           #
#-------------------------------#


# The OCID of the OKE cluster
output "oke_cluster_id" {
  description = "The OCID of the OKE cluster."
  value       = var.is_k8cluster_created ? module.oke[0].cluster_id : null
}


# The name of the OKE cluster
output "oke_cluster_name" {
  description = "The name of the OKE cluster."
  value       = var.is_k8cluster_created ? module.oke[0].cluster_name : null
}


#-------------------------------#
# Worker Node Pool Outputs      #
#-------------------------------#


# The OCIDs of the worker node pool(s) in the cluster
output "worker_node_pools_ids" {
  description = "The OCIDs of the worker node pool(s) in the OKE cluster."
  value       = var.is_nodepool_created ? module.oke[0].node_pool_ids : null
}


# The image OCIDs for the worker node pool(s)
output "worker_node_pools_image" {
  description = "The image OCIDs for the worker node pool(s)."
  value       = var.is_nodepool_created ? module.oke[0].node_pool_images : null
}